#ifndef DBASEWND_ESTILOS_H
    #define DBASEWND_ESTILOS_H

    #include "DEstilo.h"

    namespace DWL {

        class DBaseWnd_Estilos : public DEstilos {
          public :
                                    DBaseWnd_Estilos(DWORD nEstilos = NULL) : DEstilos(nEstilos) { 
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_BORDER"),              WS_BORDER));                // 0x00800000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_CAPTION"),             WS_CAPTION));   
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_CHILD"),               WS_CHILD));                 // 0x40000000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_CHILDWINDOW"),         WS_CHILDWINDOW));           // 0x40000000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_CLIPCHILDREN"),        WS_CLIPCHILDREN));          // 0x02000000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_CLIPSIBLINGS"),        WS_CLIPSIBLINGS));          // 0x04000000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_DISABLED"),            WS_DISABLED));              // 0x08000000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_DLGFRAME"),            WS_DLGFRAME));              // 0x00400000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_GROUP"),               WS_GROUP));                 // 0x00020000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_HSCROLL"),             WS_HSCROLL));               // 0x00100000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_ICONIC"),              WS_ICONIC));                // 0x20000000L WS_MINIMIZE
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_MAXIMIZE"),            WS_MAXIMIZE));              // 0x01000000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_MAXIMIZEBOX"),         WS_MAXIMIZEBOX));           // 0x00010000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_MINIMIZE"),            WS_MINIMIZE));              // 0x20000000L WS_ICONIC
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_MINIMIZEBOX"),         WS_MINIMIZEBOX));           // 0x00020000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_OVERLAPPED"),          WS_OVERLAPPED));            // 0x00000000L WS_TILED
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_OVERLAPPEDWINDOW"),    WS_OVERLAPPEDWINDOW));
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_POPUP"),               WS_POPUP));                 // 0x80000000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_POPUPWINDOW"),         WS_POPUPWINDOW));
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_SIZEBOX"),             WS_SIZEBOX));               // 0x00040000L WS_THICKFRAME
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_SYSMENU"),             WS_SYSMENU));               // 0x00080000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_TABSTOP"),             WS_TABSTOP));               // 0x00010000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_THICKFRAME"),          WS_THICKFRAME));            // 0x00040000L WS_SIZEBOX
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_TILED"),               WS_TILED));                 // 0x00000000L WS_OVERLAPPED
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_TILEDWINDOW"),         WS_TILEDWINDOW));
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_VISIBLE"),             WS_VISIBLE));               // 0x10000000L
                                        _DatosEstilos.push_back(DEstilo(TEXT("WS_VSCROLL"),             WS_VSCROLL));               // 0x00200000L
                                    };

                                    DWL_DEFINIR_ESTILO(WS_Border,           0);
                                    DWL_DEFINIR_ESTILO(WS_Caption,          1);
                                    DWL_DEFINIR_ESTILO(WS_Child,            2);
                                    DWL_DEFINIR_ESTILO(WS_ChildWindow,      3);
                                    DWL_DEFINIR_ESTILO(WS_ClipChildren,     4);
                                    DWL_DEFINIR_ESTILO(WS_ClipSiblings,     5);
                                    DWL_DEFINIR_ESTILO(WS_Disabled,         6);
                                    DWL_DEFINIR_ESTILO(WS_DialogFrame,      7);
                                    DWL_DEFINIR_ESTILO(WS_Group,            8);
                                    DWL_DEFINIR_ESTILO(WS_HScroll,          9);
                                    DWL_DEFINIR_ESTILO(WS_Iconic,           10);
                                    DWL_DEFINIR_ESTILO(WS_Maximize,         11);
                                    DWL_DEFINIR_ESTILO(WS_MaximizeBox,      12);
                                    DWL_DEFINIR_ESTILO(WS_Minimize,         13);
                                    DWL_DEFINIR_ESTILO(WS_MinimizeBox,      14);
                                    DWL_DEFINIR_ESTILO(WS_Overlapped,       15);
                                    DWL_DEFINIR_ESTILO(WS_OverlappedWindow, 16);
                                    DWL_DEFINIR_ESTILO(WS_Popup,            17);
                                    DWL_DEFINIR_ESTILO(WS_PopupWindow,      18);
                                    DWL_DEFINIR_ESTILO(WS_SizeBox,          19);
                                    DWL_DEFINIR_ESTILO(WS_SysMenu,          20);
                                    DWL_DEFINIR_ESTILO(WS_TabStop,          21);
                                    DWL_DEFINIR_ESTILO(WS_ThickFrame,       22);
                                    DWL_DEFINIR_ESTILO(WS_Tiled,            23);
                                    DWL_DEFINIR_ESTILO(WS_TiledWindow,      24);
                                    DWL_DEFINIR_ESTILO(WS_Visible,          25);
                                    DWL_DEFINIR_ESTILO(WS_VScroll,          26);

/*            inline DWORD            operator() (void)                               { return _Estilos; };
            virtual const UINT      TotalEstilos(void)                              { return _DatosEstilos.size(); };
            virtual DEstilo        *Estilo(const UINT Pos)                          { return &_DatosEstilos[Pos]; };
          protected :
            std::vector<DEstilo>   _DatosEstilos;
            DWORD                  _Estilos;*/
        };

        class DBaseWnd_EstilosEx : public DEstilos {
          public :
                                    DBaseWnd_EstilosEx(DWORD nEstilos = NULL) : DEstilos(nEstilos) { 
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_ACCEPTFILES"),      WS_EX_ACCEPTFILES));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_APPWINDOW"),        WS_EX_APPWINDOW));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_CLIENTEDGE"),       WS_EX_CLIENTEDGE));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_COMPOSITED"),       WS_EX_COMPOSITED));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_CONTEXTHELP"),      WS_EX_CONTEXTHELP));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_CONTROLPARENT"),    WS_EX_CONTROLPARENT));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_DLGMODALFRAME"),    WS_EX_DLGMODALFRAME));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_LAYERED"),          WS_EX_LAYERED));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_LAYOUTRTL"),        WS_EX_LAYOUTRTL));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_LEFT"),             WS_EX_LEFT));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_LEFTSCROLLBAR"),    WS_EX_LEFTSCROLLBAR));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_LTRREADING"),       WS_EX_LTRREADING));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_MDICHILD"),         WS_EX_MDICHILD));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_NOACTIVATE"),       WS_EX_NOACTIVATE));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_NOINHERITLAYOUT"),  WS_EX_NOINHERITLAYOUT));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_NOPARENTNOTIFY"),   WS_EX_NOPARENTNOTIFY));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_OVERLAPPEDWINDOW"), WS_EX_OVERLAPPEDWINDOW));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_PALETTEWINDOW"),    WS_EX_PALETTEWINDOW));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_RIGHT"),            WS_EX_RIGHT));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_RIGHTSCROLLBAR"),   WS_EX_RIGHTSCROLLBAR));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_RTLREADING"),       WS_EX_RTLREADING));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_STATICEDGE"),       WS_EX_STATICEDGE));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_TOOLWINDOW"),       WS_EX_TOOLWINDOW));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_TOPMOST"),          WS_EX_TOPMOST));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_TRANSPARENT"),      WS_EX_TRANSPARENT));
                                            _DatosEstilos.push_back(DEstilo(TEXT("WS_EX_WINDOWEDGE"),       WS_EX_WINDOWEDGE));
                                    };

                                    DWL_DEFINIR_ESTILO(WS_EX_AcceptFiles,       0);
                                    DWL_DEFINIR_ESTILO(WS_EX_AppWindow,         1);
                                    DWL_DEFINIR_ESTILO(WS_EX_ClientEdge,        2);
                                    DWL_DEFINIR_ESTILO(WS_EX_Composited,        3);
                                    DWL_DEFINIR_ESTILO(WS_EX_ContextHelp,       4);
                                    DWL_DEFINIR_ESTILO(WS_EX_ControlParent,     5);
                                    DWL_DEFINIR_ESTILO(WS_EX_DlgModalFrame,     6);
                                    DWL_DEFINIR_ESTILO(WS_EX_Layered,           7);
                                    DWL_DEFINIR_ESTILO(WS_EX_LayoutRTL,         8);
                                    DWL_DEFINIR_ESTILO(WS_EX_Left,              9);
                                    DWL_DEFINIR_ESTILO(WS_EX_LeftScrollBar,     10);
                                    DWL_DEFINIR_ESTILO(WS_EX_LTRReading,        11);
                                    DWL_DEFINIR_ESTILO(WS_EX_MDIChild,          12);
                                    DWL_DEFINIR_ESTILO(WS_EX_NoActivate,        13);
                                    DWL_DEFINIR_ESTILO(WS_EX_NoInheritLayout,   14);
                                    DWL_DEFINIR_ESTILO(WS_EX_NoParentNotify,    15);
                                    DWL_DEFINIR_ESTILO(WS_EX_OverlappedWindow,  16);
                                    DWL_DEFINIR_ESTILO(WS_EX_PaletteWindow,     17);
                                    DWL_DEFINIR_ESTILO(WS_EX_Right,             18);
                                    DWL_DEFINIR_ESTILO(WS_EX_RightScrollBar,    19);
                                    DWL_DEFINIR_ESTILO(WS_EX_RTLReading,        20);
                                    DWL_DEFINIR_ESTILO(WS_EX_StaticEdge,        21);
                                    DWL_DEFINIR_ESTILO(WS_EX_ToolWindow,        22);
                                    DWL_DEFINIR_ESTILO(WS_EX_TopMost,           23);
                                    DWL_DEFINIR_ESTILO(WS_EX_Transparent,       24);
                                    DWL_DEFINIR_ESTILO(WS_EX_WindowEdge,        25);

/*            inline DWORD            operator() (void)                               { return _Estilos; };
            virtual const UINT      TotalEstilos(void)                              { return _DatosEstilos.size(); };
            virtual DEstilo        *Estilo(const UINT Pos)                          { return &_DatosEstilos[Pos]; };
          protected :
            std::vector<DEstilo>   _DatosEstilos;
            DWORD                  _Estilos;*/
        };

    };

#endif